<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HospitalVctStaff extends Eloquent {

	protected $table = 'hospital_vct_staffs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('full_name');
	protected $visible = array('full_name');

	public function hospital()
	{
		return $this->belongsTo('App\Models\Hospital', 'hospital_id');
	}

}