<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('xero_id')->nullable();
			$table->integer('payment_method_id')->unsigned()->nullable()->index();
			$table->text('meta')->nullable();
			$table->integer('subtotal')->unsigned()->nullable();
			$table->integer('total')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}