<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductPartnersTable extends Migration {

	public function up()
	{
		Schema::create('product_partners', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->unique();
			$table->string('slug', 32)->unique();
			$table->string('website');
			$table->text('meta')->nullable();
			$table->string('instagram_link');
			$table->string('facebook_link');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_partners');
	}
}