<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;

class Commission extends Model 
{

    protected $table = 'commissions';
    public $timestamps = true;
    protected $fillable = array('order_id', 'order_item_id', 'product_partner_id', 'product_id', 'commission_rate_id', 'commission_amount');

    public function preset()
    {
        return $this->belongsTo('Preset');
    }

    public function order()
    {
        return $this->belongsTo('Order');
    }

    public function orderItem()
    {
        return $this->belongsTo('OrderItem');
    }

    public function photographyStudio()
    {
        return $this->belongsTo('ProductPartner');
    }

    public function commissionRate()
    {
        return $this->belongsTo('CommissionRate');
    }

}