<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfilesTable extends Migration {

	public function up()
	{
		Schema::create('user_profiles', function(Blueprint $table) {
			$table->integer('user_id')->unique()->unsigned();
			$table->string('name');
			$table->string('surname');
			$table->string('twitter');
			$table->string('phone');
			$table->string('mobile');
			$table->string('timezone');
			$table->string('date_format')->default(''d-m-Y'');
			$table->string('time_format')->default(''H:i:s'');
			$table->string('job_title');
			$table->text('public_notes');
			$table->text('admin_notes');
		});
	}

	public function down()
	{
		Schema::drop('user_profiles');
	}
}