<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_notification_prefs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_notification_prefs', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('notification_providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_notification_slack', function(Blueprint $table) {
			$table->foreign('integration_id')->references('id')->on('notification_providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_notification_slack', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users_rb_sso', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('creator')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user_profiles', function(Blueprint $table) {
			$table->dropForeign('user_profiles_user_id_foreign');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('user_notification_prefs', function(Blueprint $table) {
			$table->dropForeign('user_notification_prefs_user_id_foreign');
		});
		Schema::table('user_notification_prefs', function(Blueprint $table) {
			$table->dropForeign('user_notification_prefs_provider_id_foreign');
		});
		Schema::table('user_notification_slack', function(Blueprint $table) {
			$table->dropForeign('user_notification_slack_integration_id_foreign');
		});
		Schema::table('user_notification_slack', function(Blueprint $table) {
			$table->dropForeign('user_notification_slack_user_id_foreign');
		});
		Schema::table('users_rb_sso', function(Blueprint $table) {
			$table->dropForeign('users_rb_sso_user_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_creator_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_client_id_foreign');
		});
	}
}