<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCourtsTable extends Migration {

	public function up()
	{
		Schema::create('courts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('short_name', 255)->nullable();
			$table->string('name', 512);
			$table->string('full_name', 1024)->nullable();
			$table->integer('address_id')->unsigned();
			$table->integer('phone')->unsigned();
			$table->integer('fax')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('courts');
	}
}