<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('case_id')->unsigned()->nullable();
			$table->integer('customer_id')->unsigned();
			$table->integer('professional_ressource_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->datetime('datetime');
			$table->string('duration')->default('60');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}