<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customers extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function phones()
    {
        return $this->hasMany('Phone_numbers', 'customer_id');
    }

    public function main_address()
    {
        return $this->hasOne('Addresses', 'main_address');
    }

    public function person()
    {
        return $this->hasOne('Persons');
    }

}