<?php

namespace App/models/Proagent;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title_fr', 'title_en', 'description_fr', 'description_en', 'photo_path');

    public function posts()
    {
        return $this->hasMany('CategoryPost', 'category_id');
    }

}