<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->char('site_id', 36)->unique()->nullable();
			$table->string('name')->nullable();
			$table->string('uri')->nullable();
			$table->timestamps();
			$table->datetime('deactivated_at')->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}