<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->char('UUID', 36)->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_fr')->nullable();
			$table->string('title_en')->nullable();
			$table->string('description_fr')->nullable();
			$table->string('description_en')->nullable();
			$table->mediumText('content_fr')->nullable();
			$table->mediumText('content_en')->nullable();
			$table->string('photo_path')->nullable();
			$table->string('banner_photo_path')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}