<?php

namespace App/models/Proagent;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title_fr', 'title_en', 'description_fr', 'description_en', 'photo_path');

	public function posts()
	{
		return $this->hasMany('CategoryPost', 'category_id');
	}

}