<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->double('from_hour')->default('0');
			$table->double('to_hour')->default('0');
			$table->timestamp('date')->nullable();
			$table->enum('status', array('available', 'unavailable'));
			$table->string('bookings');
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}