<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Specialities extends Eloquent {

	protected $table = 'specialities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'icon', 'color', 'parent_id');

	public function parent()
	{
		return $this->belongsTo('Specialities', 'parent_id');
	}

}