<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('objects', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('objects', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('object_id')->references('id')->on('objects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('objects', function(Blueprint $table) {
			$table->dropForeign('objects_category_id_foreign');
		});
		Schema::table('objects', function(Blueprint $table) {
			$table->dropForeign('objects_location_id_foreign');
		});
		Schema::table('labels', function(Blueprint $table) {
			$table->dropForeign('labels_object_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_object_id_foreign');
		});
	}
}