<?php

namespace MvcCore\Jtl\Models;

class Object extends Eloquent {

	protected $table = 'objects';
	public $timestamps = true;
	protected $fillable = array('category_id', 'name', 'location_id');

	public function category()
	{
		return $this->belongsTo('MvcCore\Jtl\Models\Category');
	}

	public function images()
	{
		return $this->hasMany('MvcCore\Jtl\Models\Image');
	}

	public function features()
	{
		return $this->belongsToMany('MvcCore\Jtl\Models\Feature');
	}

	public function colors()
	{
		return $this->hasMany('MvcCore\Jtl\Models\Color');
	}

	public function labels()
	{
		return $this->hasMany('MvcCore\Jtl\Models\Label');
	}

	public function location()
	{
		return $this->belongsTo('MvcCore\Jtl\Models\Location');
	}

}