<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('password');
			$table->boolean('email_confirmation')->default(0);
			$table->string('phone');
			$table->boolean('phone_confirmation')->default(0);
			$table->string('social_id');
			$table->string('social_type');
			$table->tinyInteger('type');
			$table->string('device_id')->nullable();
			$table->integer('membership_id')->unsigned()->nullable();
			$table->double('lat');
			$table->double('long');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}