<?php

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;
	protected $fillable = array('type', 'slug', 'title', 'excerpt', 'pushed', 'url_image', 'estimated_read_time');
	protected $visible = array('type', 'slug', 'excerpt', 'pushed');

	public function products()
	{
		return $this->belongsToMany('\Product');
	}

	public function contents()
	{
		return $this->hasMany('PostContent');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

}