<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('topic_id')->unsigned()->index();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('status_id')->unsigned()->index();
			$table->text('body');
			$table->timestamps();
			$table->integer('favorites_count_raw')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}