<?php

namespace Beedask\Models;

class Vote extends Eloquent {

	protected $table = 'votes';
	public $timestamps = true;
	protected $fillable = array('answer_id', 'question_id', 'user_id');
	protected $visible = array('answer_id', 'question_id', 'user_id');

	public function answer()
	{
		return $this->belongsTo('Answer', 'answer_id');
	}

	public function question()
	{
		return $this->belongsTo('Question', 'question_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}