<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBitacoraHerramientaTable extends Migration {

	public function up()
	{
		Schema::create('BitacoraHerramienta', function(Blueprint $table) {
			$table->increments('idBitacoraHerramienta');
			$table->integer('idSolicitud')->unsigned();
			$table->integer('idHerramienta')->unsigned();
			$table->integer('cantidadPrestamo');
			$table->string('observacionesPrestamo', 250);
			$table->datetime('fechaPrestamo');
			$table->integer('idCatUbicacionPrestamo')->nullable();
			$table->integer('cantidadRecepcion')->nullable();
			$table->string('observacionesRecepcion', 250)->nullable();
			$table->datetime('fechaRecepcion')->nullable();
			$table->integer('idCatUbicacionRecepcion')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('BitacoraHerramienta');
	}
}