<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBitacoraMaterialTable extends Migration {

	public function up()
	{
		Schema::create('BitacoraMaterial', function(Blueprint $table) {
			$table->increments('idBitacoraMaterial');
			$table->integer('idSolicitud')->unsigned();
			$table->integer('idMaterial')->unsigned();
			$table->integer('cantidadPrestamo');
			$table->string('observacionesPrestamo', 250);
			$table->datetime('fechaPrestamo');
			$table->integer('idCatUbicacionPrestamo');
			$table->integer('cantidadRecepcion')->nullable();
			$table->string('observacionesRecepcion', 250)->nullable();
			$table->datetime('fechaRecepcion')->nullable();
			$table->integer('idCatUbicacionRecepcion')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('BitacoraMaterial');
	}
}