<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBitacoraEquipoTable extends Migration {

	public function up()
	{
		Schema::create('BitacoraEquipo', function(Blueprint $table) {
			$table->increments('idBitacoraEquipo');
			$table->integer('idSolicitud')->unsigned();
			$table->integer('idEquipo')->unsigned();
			$table->integer('cantidadPrestamo');
			$table->string('observacionesPrestamo', 250);
			$table->datetime('fechaPrestamo');
			$table->integer('idCatUbicacionPrestamo');
			$table->integer('cantidadRecepcion')->nullable();
			$table->string('observacionesRecepcion', 250)->nullable();
			$table->datetime('fechaRecepcion')->nullable();
			$table->integer('idCatUbicacionRecepcion')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('BitacoraEquipo');
	}
}