<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccidentsTable extends Migration {

	public function up()
	{
		Schema::create('accidents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('car_id')->unsigned()->index();
			$table->datetime('time');
			$table->text('descrtiption');
			$table->string('responsible');
			$table->tinyInteger('injured')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('accidents');
	}
}