<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevaluasiTable extends Migration {

	public function up()
	{
		Schema::create('revaluasi', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('id_tahun')->unsigned();
			$table->integer('id_sektor')->unsigned();
			$table->integer('id_perusahaan')->unsigned();
			$table->bigInteger('jumlah_aset');
			$table->enum('status', array('sudah', 'belum'));
		});
	}

	public function down()
	{
		Schema::drop('revaluasi');
	}
}