<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('Stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->smallInteger('category');
			$table->text('logo')->nullable();
			$table->string('cover')->nullable();
			$table->text('address')->nullable();
			$table->smallInteger('district_id')->unsigned();
			$table->smallInteger('province_id')->unsigned();
			$table->smallInteger('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Stores');
	}
}