<?php

class Estates extends Eloquent {

	protected $table = 'estates';
	public $timestamps = true;

	public function enstate_subtypes()
	{
		return $this->belongsTo('A');
	}

	public function enstate_subtypes()
	{
		return $this->belongsTo('AAA');
	}

	public function estate_stations()
	{
		return $this->hasMany('Estate_stations');
	}

	public function estate_images()
	{
		return $this->hasMany('Estate_images');
	}

	public function estate_slides()
	{
		return $this->hasMany('Estate_slides', 'estate_id');
	}

	public function estate_slides()
	{
		return $this->hasMany('Estate_sides', 'estate_id');
	}

	public function estate_price_logs()
	{
		return $this->hasMany('\Estate_price_logs');
	}

	public function estate_image_logs()
	{
		return $this->hasMany('Estate_image_logs');
	}

}