<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTpaPortsTable extends Migration {

	public function up()
	{
		Schema::create('tpa_ports', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('region_id')->unsigned();
			$table->string('name');
			$table->string('address');
			$table->string('imo_number')->unique();
			$table->string('port_type');
			$table->decimal('coord_lat', 3,10)->nullable();
			$table->float('teus')->nullable();
			$table->decimal('coord_lon', 3,10)->nullable();
			$table->longText('remark')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tpa_ports');
	}
}