<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTpaCompanyTable extends Migration {

	public function up()
	{
		Schema::create('tpa_company', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->string('type');
			$table->string('name');
			$table->string('address');
			$table->integer('region_id')->unsigned();
			$table->string('phone', 15);
			$table->string('company_identification');
			$table->integer('identification_type_id')->unsigned();
			$table->string('url');
			$table->integer('sector_id')->unsigned();
			$table->tinyInteger('active');
		});
	}

	public function down()
	{
		Schema::drop('tpa_company');
	}
}