<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTpaProvidersRequestTable extends Migration {

	public function up()
	{
		Schema::create('tpa_providers_request', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('provider_service_id')->unsigned();
			$table->integer('request_service_id')->unsigned();
			$table->string('quotation');
			$table->string('status');
			$table->datetime('reply-date');
			$table->integer('reservation');
			$table->integer('assigne_id')->unsigned();
			$table->tinyInteger('prevalidate')->default('0');
			$table->datetime('service_start_date');
			$table->integer('rating_provider')->nullable();
			$table->text('rating_comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tpa_providers_request');
	}
}