<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->timestamps();
			$table->integer('company_id')->unsigned();
			$table->string('firstName');
			$table->string('lastName');
			$table->string('email');
			$table->tinyInteger('active')->default('0');
			$table->date('last_login');
			$table->string('phone');
			$table->enum('type', array('admin', 'buyer', 'vendor', 'coordinator'));
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}