<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tpa_ports', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('tpa_region')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->foreign('provider_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('tpa_service_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('tpa_currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->foreign('invoice_payment_term_id')->references('id')->on('tpa_invoice_payment_terms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_field', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('tpa_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_field', function(Blueprint $table) {
			$table->foreign('field_id')->references('id')->on('tpa_fields_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('tpa_region')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->foreign('identification_type_id')->references('id')->on('tpa_identification_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->foreign('sector_id')->references('id')->on('tpa_company_sectors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_vessel', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('tpa_vessel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->foreign('port_id')->references('timestamps')->on('tpa_service_port')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->foreign('trausty_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->foreign('buyer_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_port', function(Blueprint $table) {
			$table->foreign('provider_service_id')->references('id')->on('tpa_provider_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_port', function(Blueprint $table) {
			$table->foreign('port_id')->references('id')->on('tpa_ports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->foreign('provider_service_id')->references('id')->on('tpa_provider_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->foreign('request_service_id')->references('id')->on('tpa_request_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->foreign('assigne_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_workflow', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('tpa_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_workflow', function(Blueprint $table) {
			$table->foreign('check_point_id')->references('id')->on('tpa_checkpoint')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->foreign('check_point_id')->references('check_point_id')->on('tpa_workflow')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('tpa_work_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->foreign('responsible_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->foreign('service_id')->references('service_id')->on('tpa_workflow')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_work_order', function(Blueprint $table) {
			$table->foreign('provider_request_id')->references('id')->on('tpa_providers_request')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_documents', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('tpa_work_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_notifications', function(Blueprint $table) {
			$table->foreign('work_order_id')->references('id')->on('tpa_work_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_company_documents', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_vessel_documents', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('tpa_vessel')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->foreign('request_service_id')->references('id')->on('tpa_request_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->foreign('service_id')->references('service_id')->on('tpa_service_field')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->foreign('field_id')->references('field_id')->on('tpa_service_field')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('tpa_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_request_service', function(Blueprint $table) {
			$table->foreign('request_quotation_id')->references('id')->on('tpa_request_quotation')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_settings', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_type', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('tpa_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_rate_agreement', function(Blueprint $table) {
			$table->foreign('provider_service_id')->references('id')->on('tpa_provider_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_rate_agreement', function(Blueprint $table) {
			$table->foreign('buyer_id')->references('id')->on('tpa_company')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->foreign('document_id')->references('id')->on('tpa_required_documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->foreign('service_type_id')->references('id')->on('tpa_service_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->foreign('port_id')->references('id')->on('tpa_ports')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service_documents', function(Blueprint $table) {
			$table->foreign('service_document_id')->references('id')->on('tpa_service_documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tpa_provider_service_documents', function(Blueprint $table) {
			$table->foreign('provider_service_id')->references('id')->on('tpa_provider_service')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tpa_ports', function(Blueprint $table) {
			$table->dropForeign('tpa_ports_region_id_foreign');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_provider_id_foreign');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_service_type_id_foreign');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_currency_id_foreign');
		});
		Schema::table('tpa_provider_service', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_invoice_payment_term_id_foreign');
		});
		Schema::table('tpa_service_field', function(Blueprint $table) {
			$table->dropForeign('tpa_service_field_service_id_foreign');
		});
		Schema::table('tpa_service_field', function(Blueprint $table) {
			$table->dropForeign('tpa_service_field_field_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->dropForeign('tpa_company_region_id_foreign');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->dropForeign('tpa_company_identification_type_id_foreign');
		});
		Schema::table('tpa_company', function(Blueprint $table) {
			$table->dropForeign('tpa_company_sector_id_foreign');
		});
		Schema::table('tpa_vessel', function(Blueprint $table) {
			$table->dropForeign('tpa_vessel_company_id_foreign');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->dropForeign('tpa_request_quotation_buyer_id_foreign');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->dropForeign('tpa_request_quotation_vessel_id_foreign');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->dropForeign('tpa_request_quotation_port_id_foreign');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->dropForeign('tpa_request_quotation_trausty_user_id_foreign');
		});
		Schema::table('tpa_request_quotation', function(Blueprint $table) {
			$table->dropForeign('tpa_request_quotation_buyer_user_id_foreign');
		});
		Schema::table('tpa_service_port', function(Blueprint $table) {
			$table->dropForeign('tpa_service_port_provider_service_id_foreign');
		});
		Schema::table('tpa_service_port', function(Blueprint $table) {
			$table->dropForeign('tpa_service_port_port_id_foreign');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->dropForeign('tpa_providers_request_provider_service_id_foreign');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->dropForeign('tpa_providers_request_request_service_id_foreign');
		});
		Schema::table('tpa_providers_request', function(Blueprint $table) {
			$table->dropForeign('tpa_providers_request_assigne_id_foreign');
		});
		Schema::table('tpa_workflow', function(Blueprint $table) {
			$table->dropForeign('tpa_workflow_service_id_foreign');
		});
		Schema::table('tpa_workflow', function(Blueprint $table) {
			$table->dropForeign('tpa_workflow_check_point_id_foreign');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->dropForeign('tpa_execution_wf_check_point_id_foreign');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->dropForeign('tpa_execution_wf_work_order_id_foreign');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->dropForeign('tpa_execution_wf_responsible_id_foreign');
		});
		Schema::table('tpa_execution_wf', function(Blueprint $table) {
			$table->dropForeign('tpa_execution_wf_service_id_foreign');
		});
		Schema::table('tpa_work_order', function(Blueprint $table) {
			$table->dropForeign('tpa_work_order_provider_request_id_foreign');
		});
		Schema::table('tpa_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_documents_work_order_id_foreign');
		});
		Schema::table('tpa_notifications', function(Blueprint $table) {
			$table->dropForeign('tpa_notifications_work_order_id_foreign');
		});
		Schema::table('tpa_company_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_company_documents_company_id_foreign');
		});
		Schema::table('tpa_vessel_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_vessel_documents_vessel_id_foreign');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->dropForeign('tpa_request_field_request_service_id_foreign');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->dropForeign('tpa_request_field_service_id_foreign');
		});
		Schema::table('tpa_request_field', function(Blueprint $table) {
			$table->dropForeign('tpa_request_field_field_id_foreign');
		});
		Schema::table('tpa_request_service', function(Blueprint $table) {
			$table->dropForeign('tpa_request_service_service_id_foreign');
		});
		Schema::table('tpa_request_service', function(Blueprint $table) {
			$table->dropForeign('tpa_request_service_request_quotation_id_foreign');
		});
		Schema::table('tpa_settings', function(Blueprint $table) {
			$table->dropForeign('tpa_settings_user_id_foreign');
		});
		Schema::table('tpa_service_type', function(Blueprint $table) {
			$table->dropForeign('tpa_service_type_service_id_foreign');
		});
		Schema::table('tpa_rate_agreement', function(Blueprint $table) {
			$table->dropForeign('tpa_rate_agreement_provider_service_id_foreign');
		});
		Schema::table('tpa_rate_agreement', function(Blueprint $table) {
			$table->dropForeign('tpa_rate_agreement_buyer_id_foreign');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_service_documents_document_id_foreign');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_service_documents_service_type_id_foreign');
		});
		Schema::table('tpa_service_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_service_documents_port_id_foreign');
		});
		Schema::table('tpa_provider_service_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_documents_service_document_id_foreign');
		});
		Schema::table('tpa_provider_service_documents', function(Blueprint $table) {
			$table->dropForeign('tpa_provider_service_documents_provider_service_id_foreign');
		});
	}
}