<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogTable extends Migration {

	public function up()
	{
		Schema::create('blog', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('slug');
			$table->string('content');
			$table->string('high_lighted_text');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->integer('deleted_by');
			$table->timestampsTz('publish_date');
			$table->timestampsTz('created_at');
			$table->timestampsTz('updated_at');
			$table->timestampsTz('deleted_at');
			$table->integer('blog_flag');
		});
	}

	public function down()
	{
		Schema::drop('blog');
	}
}