<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->mediumText('content');
			$table->string('slug');
			$table->integer('parent_id');
			$table->string('meta_title');
			$table->string('meta_description');
			$table->integer('category_id')->unsigned();
			$table->string('layout');
			$table->string('feature_image');
			$table->json('meta_info');
			$table->integer('created_by');
			$table->integer('updated_by');
			$table->timestampTz('publish_date');
			$table->timestampTz('created_at');
			$table->timestampTz('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}