<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTractoresTable extends Migration {

	public function up()
	{
		Schema::create('tractores', function(Blueprint $table) {
			$table->mediumInteger('id_tractor', true);
			$table->mediumInteger('id_chofer');
			$table->mediumInteger('id_status');
			$table->string('marca', 60)->nullable();
			$table->string('modelo', 60);
			$table->string('num_vehiculo', 10);
			$table->string('placas', 20);
			$table->string('vin', 50);
			$table->string('color', 30);
			$table->mediumInteger('id_usuario_registro');
			$table->mediumInteger('id_usuario_ult_mod');
			$table->datetime('fecha_ult_mod');
			$table->mediumInteger('id_tipo_tractor');
			$table->mediumInteger('id_cliente');
			$table->string('foto_tractor', 100);
			$table->string('foto_placas');
			$table->string('foto_marca');
			$table->string('foto_vin', 100);
		});
	}

	public function down()
	{
		Schema::drop('tractores');
	}
}