<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Caja extends Model 
{

    protected $table = 'cajas';
    public $timestamps = false;
    protected $fillable = array('fecha_ult_mod', 'id_usuario_registro', 'id_usuario_ult_mod', 'id_tipo', 'marca_llanta2', 'marca_llanta3', 'marca_llanta4', 'marca_llanta5', 'marca_llanta6', 'marca_llanta7', 'marca_llanta8');

    public function tipo()
    {
        return $this->belongsTo('App\TipoCaja', 'id_tipo', 'id_tipo');
    }

    public function tamano()
    {
        return $this->belongsTo('App\TamanoCaja', 'id_tamano', 'id_tamano');
    }

    public function status()
    {
        return $this->belongsTo('App\Status', 'id_status', 'id_status');
    }

    public function cliente()
    {
        return $this->belongsTo('App\Cliente', 'id_cliente', 'id_cliente');
    }

}