<?php

namespace lhp;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NotaPemeriksaan extends Eloquent {

	protected $table = 'np';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('np_nomor', 'np_tanggal', 'np_lhp', 'np_upt', 'np_temuan');
	protected $visible = array('np_nomor', 'np_tanggal', 'np_lhp', 'np_upt', 'np_temuan');

	public function getLhp()
	{
		return $this->hasOne('lhp\Lhp', 'np_lhp');
	}

	public function getUpt()
	{
		return $this->hasOne('upt\Upt', 'np_upt');
	}

	public function getNpTemuan()
	{
		return $this->hasMany('np\NpTemuan', 'np_temuan');
	}

}