<?php

namespace np;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NpTemuan extends Eloquent {

	protected $table = 'np_temuan';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('np_temuan_analisis', 'np_temuan_kesimpulan', 'np_temuan_saran');
	protected $visible = array('np_temuan_analisis', 'np_temuan_kesimpulan', 'np_temuan_saran');

	public function getNpAnalisis()
	{
		return $this->hasOne('np\NpAnalisis', 'np_temuan_analisis');
	}

	public function getNpSaran()
	{
		return $this->hasOne('np\NpSaran', 'np_temuan_saran');
	}

	public function getNpKesimpulan()
	{
		return $this->hasOne('np\NpKesimpulan', 'np_temuan_kesimpulan');
	}

}