<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('kinerja', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('iki_sasaran_program', function(Blueprint $table) {
			$table->foreign('kinerjai_id')->references('id')->on('kinerja')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('iki_indikator', function(Blueprint $table) {
			$table->foreign('iki_sasaran_program_id')->references('id')->on('iki_sasaran_program')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pk', function(Blueprint $table) {
			$table->foreign('iki_indikator_id')->references('id')->on('iki_indikator')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('program_kegiatan', function(Blueprint $table) {
			$table->foreign('kinerja_id')->references('id')->on('kinerja')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ppk', function(Blueprint $table) {
			$table->foreign('kinerja_id')->references('id')->on('kinerja')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skp_kegiatan', function(Blueprint $table) {
			$table->foreign('skp_id')->references('id')->on('skp')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skp_tugas_penilaian', function(Blueprint $table) {
			$table->foreign('skp_tugas_id')->references('id')->on('skp_tugas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skp_kreativitas', function(Blueprint $table) {
			$table->foreign('skp_id')->references('id')->on('skp')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ppk_perilaku', function(Blueprint $table) {
			$table->foreign('ppk_id')->references('id')->on('ppk')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ppk_perilaku_penilaian', function(Blueprint $table) {
			$table->foreign('ppk_perilaku_id')->references('id')->on('ppk_perilaku')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skp_tugas', function(Blueprint $table) {
			$table->foreign('skp_id')->references('id')->on('skp')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skp_kreativitas_penilaian', function(Blueprint $table) {
			$table->foreign('skp_kreativitas_id')->references('id')->on('skp_kreativitas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tunjangan', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('kinerja', function(Blueprint $table) {
			$table->dropForeign('kinerja_pegawai_id_foreign');
		});
		Schema::table('iki_sasaran_program', function(Blueprint $table) {
			$table->dropForeign('iki_sasaran_program_kinerjai_id_foreign');
		});
		Schema::table('iki_indikator', function(Blueprint $table) {
			$table->dropForeign('iki_indikator_iki_sasaran_program_id_foreign');
		});
		Schema::table('pk', function(Blueprint $table) {
			$table->dropForeign('pk_iki_indikator_id_foreign');
		});
		Schema::table('program_kegiatan', function(Blueprint $table) {
			$table->dropForeign('program_kegiatan_kinerja_id_foreign');
		});
		Schema::table('ppk', function(Blueprint $table) {
			$table->dropForeign('ppk_kinerja_id_foreign');
		});
		Schema::table('skp_kegiatan', function(Blueprint $table) {
			$table->dropForeign('skp_kegiatan_skp_id_foreign');
		});
		Schema::table('skp_tugas_penilaian', function(Blueprint $table) {
			$table->dropForeign('skp_tugas_penilaian_skp_tugas_id_foreign');
		});
		Schema::table('skp_kreativitas', function(Blueprint $table) {
			$table->dropForeign('skp_kreativitas_skp_id_foreign');
		});
		Schema::table('ppk_perilaku', function(Blueprint $table) {
			$table->dropForeign('ppk_perilaku_ppk_id_foreign');
		});
		Schema::table('ppk_perilaku_penilaian', function(Blueprint $table) {
			$table->dropForeign('ppk_perilaku_penilaian_ppk_perilaku_id_foreign');
		});
		Schema::table('skp_tugas', function(Blueprint $table) {
			$table->dropForeign('skp_tugas_skp_id_foreign');
		});
		Schema::table('skp_kreativitas_penilaian', function(Blueprint $table) {
			$table->dropForeign('skp_kreativitas_penilaian_skp_kreativitas_id_foreign');
		});
		Schema::table('tunjangan', function(Blueprint $table) {
			$table->dropForeign('tunjangan_pegawai_id_foreign');
		});
	}
}