<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFundsTable extends Migration {

	public function up()
	{
		Schema::create('funds', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fundReference', 40)->nullable();
			$table->string('fundGroup', 20)->nullable();
			$table->timestamps();
			$table->date('startDateYear');
			$table->date('endDateYear');
			$table->date('year');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('funds');
	}
}