<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMembersTable extends Migration {

	public function up()
	{
		Schema::create('members', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('fund_id')->unsigned();
			$table->string('memberReference', 40)->nullable();
			$table->date('superAccountCommencement')->nullable();
			$table->decimal('superAccountOpeningBalance', 11,2);
			$table->decimal('superAccountClosingBalance', 11,2);
			$table->date('pensionAccountCommencement')->nullable();
			$table->decimal('pensionAccountOpeningBalance', 11,2);
			$table->decimal('pensionAccountClosingBalance', 11,2);
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('members');
	}
}