<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuperTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('superTransactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('transcationDate');
			$table->enum('transcationType', array(''ConcessionalContribution'', ''NonConcessionalContribution'', ''OpeningBalance'', ''TransferIn'', ''PensionPayment'', ''Withdrawal''));
			$table->decimal('transcationAmount', 11,2);
			$table->integer('member_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('superTransactions');
	}
}