<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('quiz_section_id')->references('id')->on('quiz_sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('question_type_id')->references('id')->on('question_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_sections', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizzes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_choices', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user', function(Blueprint $table) {
			$table->foreign('quiz_id')->references('id')->on('quizzes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quiz_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_question_answer', function(Blueprint $table) {
			$table->foreign('quiz_user_id')->references('id')->on('quiz_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_question_answer', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_table_variables', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('question_table_variables', function(Blueprint $table) {
			$table->foreign('input_type_id')->references('id')->on('input_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_quiz_section_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_parent_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_question_type_id_foreign');
		});
		Schema::table('quiz_sections', function(Blueprint $table) {
			$table->dropForeign('quiz_sections_quiz_id_foreign');
		});
		Schema::table('question_choices', function(Blueprint $table) {
			$table->dropForeign('question_choices_question_id_foreign');
		});
		Schema::table('quiz_user', function(Blueprint $table) {
			$table->dropForeign('quiz_user_quiz_id_foreign');
		});
		Schema::table('quiz_user', function(Blueprint $table) {
			$table->dropForeign('quiz_user_user_id_foreign');
		});
		Schema::table('user_question_answer', function(Blueprint $table) {
			$table->dropForeign('user_question_answer_quiz_user_id_foreign');
		});
		Schema::table('user_question_answer', function(Blueprint $table) {
			$table->dropForeign('user_question_answer_question_id_foreign');
		});
		Schema::table('question_table_variables', function(Blueprint $table) {
			$table->dropForeign('question_table_variables_question_id_foreign');
		});
		Schema::table('question_table_variables', function(Blueprint $table) {
			$table->dropForeign('question_table_variables_input_type_id_foreign');
		});
	}
}