<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImpressionsTable extends Migration {

	public function up()
	{
		Schema::create('impressions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid');
			$table->integer('position_id')->unsigned();
			$table->integer('ad_group_id')->unsigned();
			$table->integer('ad_id')->unsigned();
			$table->integer('country');
			$table->string('browser');
			$table->string('language');
			$table->string('operation_system');
			$table->string('domain');
			$table->string('protocol');
			$table->string('is_human');
			$table->string('impress_time');
			$table->string('ad_type');
			$table->string('ip_v4');
			$table->float('cost');
		});
	}

	public function down()
	{
		Schema::drop('impressions');
	}
}