<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductItemsTable extends Migration {

	public function up()
	{
		Schema::create('product_items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->decimal('price');
			$table->decimal('mb');
			$table->text('short_description');
			$table->text('long_description');
			$table->string('slug');
			$table->integer('product_id')->unsigned();
			$table->integer('order')->nullable();
			$table->integer('status')->nullable();
			$table->tinyInteger('is_popular')->nullable();
			$table->timestamps();
			$table->string('order_link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product_items');
	}
}