<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->foreign('fight_id')->references('id')->on('fights')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fights', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('fights', function(Blueprint $table) {
			$table->foreign('enemy_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('item_player', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('item_player', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_item', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_item', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_player', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_player', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('player_user', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('class_player', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('class_player', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ability_class', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ability_class', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('armour', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('armour', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_class', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('attribute_class', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('classes')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ability_player', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ability_player', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('weapons', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('weapons', function(Blueprint $table) {
			$table->foreign('player_id')->references('id')->on('players')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('ability_item', function(Blueprint $table) {
			$table->foreign('ability_id')->references('id')->on('abilities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ability_item', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->dropForeign('fight_steps_fight_id_foreign');
		});
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->dropForeign('fight_steps_player_id_foreign');
		});
		Schema::table('fight_steps', function(Blueprint $table) {
			$table->dropForeign('fight_steps_ability_id_foreign');
		});
		Schema::table('fights', function(Blueprint $table) {
			$table->dropForeign('fights_player_id_foreign');
		});
		Schema::table('fights', function(Blueprint $table) {
			$table->dropForeign('fights_enemy_id_foreign');
		});
		Schema::table('item_player', function(Blueprint $table) {
			$table->dropForeign('item_player_item_id_foreign');
		});
		Schema::table('item_player', function(Blueprint $table) {
			$table->dropForeign('item_player_player_id_foreign');
		});
		Schema::table('attribute_item', function(Blueprint $table) {
			$table->dropForeign('attribute_item_attribute_id_foreign');
		});
		Schema::table('attribute_item', function(Blueprint $table) {
			$table->dropForeign('attribute_item_item_id_foreign');
		});
		Schema::table('attribute_player', function(Blueprint $table) {
			$table->dropForeign('attribute_player_attribute_id_foreign');
		});
		Schema::table('attribute_player', function(Blueprint $table) {
			$table->dropForeign('attribute_player_player_id_foreign');
		});
		Schema::table('player_user', function(Blueprint $table) {
			$table->dropForeign('player_user_player_id_foreign');
		});
		Schema::table('class_player', function(Blueprint $table) {
			$table->dropForeign('class_player_class_id_foreign');
		});
		Schema::table('class_player', function(Blueprint $table) {
			$table->dropForeign('class_player_player_id_foreign');
		});
		Schema::table('ability_class', function(Blueprint $table) {
			$table->dropForeign('ability_class_ability_id_foreign');
		});
		Schema::table('ability_class', function(Blueprint $table) {
			$table->dropForeign('ability_class_class_id_foreign');
		});
		Schema::table('armour', function(Blueprint $table) {
			$table->dropForeign('armour_item_id_foreign');
		});
		Schema::table('armour', function(Blueprint $table) {
			$table->dropForeign('armour_player_id_foreign');
		});
		Schema::table('attribute_class', function(Blueprint $table) {
			$table->dropForeign('attribute_class_attribute_id_foreign');
		});
		Schema::table('attribute_class', function(Blueprint $table) {
			$table->dropForeign('attribute_class_class_id_foreign');
		});
		Schema::table('ability_player', function(Blueprint $table) {
			$table->dropForeign('ability_player_ability_id_foreign');
		});
		Schema::table('ability_player', function(Blueprint $table) {
			$table->dropForeign('ability_player_player_id_foreign');
		});
		Schema::table('weapons', function(Blueprint $table) {
			$table->dropForeign('weapons_item_id_foreign');
		});
		Schema::table('weapons', function(Blueprint $table) {
			$table->dropForeign('weapons_player_id_foreign');
		});
		Schema::table('ability_item', function(Blueprint $table) {
			$table->dropForeign('ability_item_ability_id_foreign');
		});
		Schema::table('ability_item', function(Blueprint $table) {
			$table->dropForeign('ability_item_item_id_foreign');
		});
	}
}