<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Livre extends Model 
{

    protected $table = 'Livre';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getnotation()
    {
        return $this->hasMany('Commentaire');
    }

    public function getcommande()
    {
        return $this->hasMany('Commande');
    }

    public function getcategorie()
    {
        return $this->hasMany('Categorie');
    }

    public function getsouscategorie()
    {
        return $this->hasOne('Souscategorie');
    }

}