<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUtilisateurTable extends Migration {

	public function up()
	{
		Schema::create('Utilisateur', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('Nom');
			$table->string('email');
			$table->string('password');
			$table->enum('statuts', array('abonne', 'non_abonnes', 'auteur', 'admin', 'narrateur', 'dev'));
			$table->enum('profession', array('étudiants', 'salarie', 'entrepreneur', 'cadre'));
			$table->string('categorie_prefere');
			$table->enum('etat', array('active', 'en_attente', 'suspendu', 'supprime'));
		});
	}

	public function down()
	{
		Schema::drop('Utilisateur');
	}
}