<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('items_table', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories_table')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('users_table')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details_table', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details_table', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('users_table')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments_table', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_details_table', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('package_details_table', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('users_table')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('items_table', function(Blueprint $table) {
			$table->dropForeign('items_table_category_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_item_id_foreign');
		});
		Schema::table('order_details_table', function(Blueprint $table) {
			$table->dropForeign('order_details_table_order_id_foreign');
		});
		Schema::table('order_details_table', function(Blueprint $table) {
			$table->dropForeign('order_details_table_package_id_foreign');
		});
		Schema::table('payments_table', function(Blueprint $table) {
			$table->dropForeign('payments_table_order_id_foreign');
		});
		Schema::table('package_details_table', function(Blueprint $table) {
			$table->dropForeign('package_details_table_package_id_foreign');
		});
		Schema::table('package_details_table', function(Blueprint $table) {
			$table->dropForeign('package_details_table_item_id_foreign');
		});
	}
}